from MouseCamera import MouseCamera
from TextureBox import TextureBox

mouseCamera = None
blocks = list()

def square(r=5, y=0, tname="cobblestone"):
    if r % 2 == 0:
        return

    herf = (r - 1) / 2

    for x in range(-herf, herf+1):
        blocks.append(TextureBox(tname, x, y, -herf))
        blocks.append(TextureBox(tname, x, y, herf))

    for z in range(-(herf-1), herf):
        blocks.append(TextureBox(tname, -herf, y, z))
        blocks.append(TextureBox(tname, herf, y, z))

def setup():
    global mouseCamera, blocks
    size(800,800, P3D)
    textureMode(NORMAL)
    mouseCamera = MouseCamera()

    blocks.append(TextureBox("cobblestone", 0, -20, 0))

    for x in range(-10, 11):
        for z in range(-10, 11):
            blocks.append(TextureBox("grass_block", x, 1, z))

    y=0
    for i in range(19, 0, -4):
        square(i, y, "tnt")
        y-=2


def draw():
    background(200)
    mouseCamera.update()
    for block in blocks:
        block.draw()
    if blocks[0].y < 0:
        blocks[0].y += 0.01

def mousePressed():
    mouseCamera.mousePressed()
def mouseDragged():
    mouseCamera.mouseDragged()
def mouseWheel(event):
    mouseCamera.mouseWheel(event)
