# coding: utf-8

import os

class TextureBox:
    NAME = list()
    NAME.append("grass_block")
    NAME.append("tnt")
    NAME.append("cobblestone")
    IMG = dict()
    TEXTURE_LOADED = False

    def __init__(self, textureName="tnt", x=0, y=0, z=0):
        self.loadTexture()
        imgs = TextureBox.IMG[textureName]
        self.tex_top = imgs[0]
        self.tex_side = imgs[0]
        self.tex_bottom = imgs[0]
        if len(imgs) >= 2:
            self.tex_top = imgs[1]
        if len(imgs) >= 3:
            self.tex_bottom = imgs[2]
        self.box_size = 50
        self.x = x
        self.y = y
        self.z = z

    def loadTexture(self):
        if TextureBox.TEXTURE_LOADED == False:
            for name in TextureBox.NAME:
                imgs = list()
                for i in range(3):
                    fname = name + str(i) + ".png"
                    path = os.getcwd() + "\\data\\" + fname
                    if os.path.isfile(path):
                        imgs.append(loadImage(fname))
                TextureBox.IMG[name] = imgs
            TextureBox.TEXTURE_LOADED = True

    def draw(self):
        noFill()
        noStroke()

        beginShape(QUADS)
        pushMatrix()
        scale(self.box_size, self.box_size, self.box_size)
        translate(self.x - 0.5, self.y + 0.5, self.z + 0.5)
        # +Z "front" face
        texture(self.tex_side)
        vertex(0, -1, -1, 0, 0)
        vertex(1, -1, -1, 1, 0)
        vertex(1, 0, -1, 1, 1)
        vertex(0, 0, -1, 0, 1)
        # -Z "back" face
        vertex(0, -1, 0, 0, 0)
        vertex(1, -1, 0, 1, 0)
        vertex(1, 0, 0, 1, 1)
        vertex(0, 0, 0, 0, 1)
        # +X "right" face
        vertex(1, -1, 0, 0, 0)
        vertex(1, -1, -1, 1, 0)
        vertex(1, 0, -1, 1, 1)
        vertex(1, 0, 0, 0, 1)
        # -X "left" face
        vertex(0, -1, 0, 0, 0)
        vertex(0, -1, -1, 1, 0)
        vertex(0, 0, -1, 1, 1)
        vertex(0, 0, 0, 0, 1)
        endShape()

        beginShape(QUADS)
        # -Y "top" face
        texture(self.tex_top)
        vertex(1, -1, 0, 0, 0)
        vertex(1, -1, -1, 1, 0)
        vertex(0, -1, -1, 1, 1)
        vertex(0, -1, 0, 0, 1)
        endShape()

        beginShape(QUADS)
        # +Y "bottom" face
        texture(self.tex_bottom)
        vertex(1, 0, 0, 0, 0)
        vertex(1, 0, -1, 1, 0)
        vertex(0, 0, -1, 1, 1)
        vertex(0, 0, 0, 0, 1)
        endShape()

        popMatrix()
